package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;
import java.util.Date;

/** Read only transfer object for logging extracts
 * User: Rob Murtha
 */
public class ExtractLog implements Serializable {
    
	private Date createdDate;
	private String operationName;
	private String status;
	private String icn;
	private String stationNumber;
	private String extractType;
	private Date startDate;
	private Date endDate;
	private Long recordCount;
	private long retryCount;
	private long messageId;

    private static final long serialVersionUID = 3530864772214658106L;
    
    public ExtractLog(long messageId, String operationName, String status, String icn, String stationNumber, String extractType, Date startDate, Date endDate) {
        
        this(messageId, new Date(), operationName, status, icn, stationNumber, extractType, startDate, endDate);

    }

    public ExtractLog(long messageId, Date createdDate, String operationName, String status, String icn, String stationNumber, String extractType, Date startDate, Date endDate) {
        this.messageId = messageId;
        this.createdDate = createdDate;
        this.operationName = operationName;
        this.status = status;
        this.icn = icn;
        this.stationNumber = stationNumber;
        this.extractType = extractType;
        this.startDate = startDate;
        this.endDate = endDate;
    }
    
    public Date getCreatedDate() {
		return createdDate;
	}
    
    public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

    public String getOperationName() {
        return operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public String getExtractType() {
        return extractType;
    }

    public void setExtractType(String extractType) {
        this.extractType = extractType;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getRecordCount() {
        return recordCount==null ? 0L : recordCount;
    }

    public void setRecordCount(Long recordCount) {
        this.recordCount = recordCount;
    }

    public long getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(long retryCount) {
        this.retryCount = retryCount;
    }

    public long getMessageId() {
        return messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof ExtractLog)) return false;

    ExtractLog that = (ExtractLog) o;

    if (messageId != that.messageId) return false;
    if (retryCount != that.retryCount) return false;
    if (endDate != null ? !endDate.equals(that.endDate) : that.endDate != null) return false;
    if (extractType != null ? !extractType.equals(that.extractType) : that.extractType != null) return false;
    if (icn != null ? !icn.equals(that.icn) : that.icn != null) return false;
    if (operationName != null ? !operationName.equals(that.operationName) : that.operationName != null) return false;
    if (recordCount != null ? !recordCount.equals(that.recordCount) : that.recordCount != null) return false;
    if (startDate != null ? !startDate.equals(that.startDate) : that.startDate != null) return false;
    if (stationNumber != null ? !stationNumber.equals(that.stationNumber) : that.stationNumber != null) return false;
    if (status != null ? !status.equals(that.status) : that.status != null) return false;

    return true;
}

    public int hashCode() {
        int result;
        result = (operationName != null ? operationName.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (icn != null ? icn.hashCode() : 0);
        result = 31 * result + (stationNumber != null ? stationNumber.hashCode() : 0);
        result = 31 * result + (extractType != null ? extractType.hashCode() : 0);
        result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
        result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
        result = 31 * result + (recordCount != null ? recordCount.hashCode() : 0);
        result = 31 * result + (int) (retryCount ^ (retryCount >>> 32));
        result = 31 * result + (int) (messageId ^ (messageId >>> 32));
        return result;
    }

    public String toString() {
        return "ExtractLog{" +
                "operationName='" + operationName + '\'' +
                ", status='" + status + '\'' +
                ", icn='" + icn + '\'' +
                ", stationNumber='" + stationNumber + '\'' +
                ", extractType='" + extractType + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", recordCount=" + recordCount +
                ", retryCount=" + retryCount +
                ", messageId=" + messageId +
                '}';
    }
}
